﻿# -*- coding: utf-8 -*-
## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
from CvPythonExtensions import *
import CvUtil
import ScreenInput
import CvScreenEnums
import CvScreensInterface

TEXTURE_SIZE = 24
X_START = 6
X_INCREMENT = 27
Y_ROW = 32

# globals
gc = CyGlobalContext()
ArtFileMgr = CyArtFileMgr()
localText = CyTranslator()

import BugUtil

class CvLegionScreen:
	"Legion Screen"

	def __init__(self):
		self.bRegroup = False

		self.xPanelWidth = 848
		self.yPanelHeight = 600

		self.iMargin = 15
		self.iPortraitSize = 240
		self.iStatsHeight = 120
		self.iIncrement = 4

		self.iButtonWidth = 76
		self.iButtonHeight = 30

		self.InitLegionMemberList = []
		self.InitNotSamePlotMemberList = []
		self.InitHasMovedMemberList = []

		self.LegionCoreTroopCheck = {}
		self.LegionMemberCheck = {}

		self.CombatUnitDict = {"UNITCOMBAT_MELEE"    :    [],
				       "UNITCOMBAT_MOUNTED"  :    [],
				       "UNITCOMBAT_ARCHER"   :    [],
				       "UNITCOMBAT_SIEGE"    :    [],
				       "UNITCOMBAT_NAVAL"    :    []}

		self.PerceivedUnitCombatLevels = {"UNITCOMBAT_MELEE"    :    0,
						  "UNITCOMBAT_MOUNTED"  :    0,
						  "UNITCOMBAT_ARCHER"   :    0,
						  "UNITCOMBAT_SIEGE"    :    0,
						  "UNITCOMBAT_NAVAL"    :    0}

		self.PerceivedUniquePromotions = []
		self.PerceivedMemberPromotions = []             

		self.iHero = -1
		self.iUnitID = -1
		self.iPlayer = -1

	def getScreen(self):
		return CyGInterfaceScreen( "LegionScreen", CvScreenEnums.LEGION_SCREEN )

	def hideScreen (self):
		# Get the screen
		screen = self.getScreen()

		# Hide the screen
		screen.hideScreen()

	# Screen construction function
	def interfaceScreen(self, iHero, bRegroup):
		self.iHero = iHero
		self.bRegroup = bRegroup
		self.iUnitID = gc.getGame().getHeroUnitID(iHero)
		self.iPlayer = gc.getGame().getHeroDebutStatus(iHero)

		screen = self.getScreen()
		screen.setRenderInterfaceOnly(True)
		screen.showScreen(PopupStates.POPUPSTATE_IMMEDIATE, False)

		self.nWidgetCount = 0
		self.sWidgets = []

		self.InitLegionMemberList = []

		pHero = gc.getPlayer(self.iPlayer).getUnit(self.iUnitID)

		for iIndex in range( gc.getGame().getHeroLegionSize(iHero) ):
			self.InitLegionMemberList.append( gc.getGame().getHeroLegionMemberAt(iHero, iIndex) )

		self.InitNotSamePlotMemberList = []
		self.InitHasMovedMemberList = []

		if len(self.InitLegionMemberList) > 0:
			pPlayer = gc.getPlayer(self.iPlayer)
			pCoreTroop = pPlayer.getUnit(self.iUnitID)
			pPlot = pCoreTroop.plot()
			for iUnitID in self.InitLegionMemberList:
				if pPlayer.getUnit(iUnitID).plot().getX() != pPlot.getX() or pPlayer.getUnit(iUnitID).plot().getY() != pPlot.getY():
					self.InitNotSamePlotMemberList.append(iUnitID)
				if pPlayer.getUnit(iUnitID).hasMoved() or pPlayer.getUnit(iUnitID).isHurt():
					self.InitHasMovedMemberList.append(iUnitID)

		self.LegionCoreTroopCheck.clear()
		self.LegionMemberCheck.clear()
		for key in self.CombatUnitDict.keys():
			self.CombatUnitDict[key] = []

		xPanelWidth = self.xPanelWidth
		yPanelHeight = self.yPanelHeight

		iX = (screen.getXResolution() - xPanelWidth) / 2
		iY = (screen.getYResolution() - yPanelHeight) / 2
		iMargin = self.iMargin

		screen.showWindowBackground( False )
##		screen.setDimensions(iX, iY, xPanelWidth, yPanelHeight)

		screen.addPanel( "LegionMainPanel", u"", u"", True, True, iX, iY, xPanelWidth, yPanelHeight, PanelStyles.PANEL_STYLE_MAIN )
		screen.addPanel( "HeroPortraitPanel", u"", u"", True, False, iX + self.iIncrement * 3, iY + self.iIncrement * 2, self.iPortraitSize + 2 * (iMargin - self.iIncrement * 3), self.iPortraitSize + 2 * (iMargin - self.iIncrement * 2), PanelStyles.PANEL_STYLE_BLUE50 )

		if len(self.InitNotSamePlotMemberList) == 0 and len(self.InitHasMovedMemberList) == 0:
			screen.setButtonGFC( "Clear", localText.getText("TXT_KEY_SCREEN_CLEAR", ()), "", iX + xPanelWidth - self.iButtonWidth * 3 - self.iIncrement * 10, iY + yPanelHeight - self.iButtonHeight - self.iIncrement * 4, self.iButtonWidth, self.iButtonHeight, WidgetTypes.WIDGET_GENERAL, -1, -1, ButtonStyles.BUTTON_STYLE_STANDARD )
			screen.setActivation( "Clear", ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )
		screen.setButtonGFC( "Cancel", localText.getText("TXT_KEY_SCREEN_CANCEL", ()), "", iX + xPanelWidth - self.iButtonWidth * 2 - self.iIncrement * 9, iY + yPanelHeight - self.iButtonHeight - self.iIncrement * 4, self.iButtonWidth, self.iButtonHeight, WidgetTypes.WIDGET_CLOSE_SCREEN, -1, -1, ButtonStyles.BUTTON_STYLE_STANDARD )
		screen.setActivation( "Cancel", ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )
		screen.setButtonGFC( "Confirm", localText.getText("TXT_KEY_SCREEN_CONFIRM", ()), "", iX + xPanelWidth - self.iButtonWidth - self.iIncrement * 8, iY + yPanelHeight - self.iButtonHeight - self.iIncrement * 4, self.iButtonWidth, self.iButtonHeight, WidgetTypes.WIDGET_FORM_LEGION, self.bRegroup, self.iHero, ButtonStyles.BUTTON_STYLE_STANDARD )
		screen.setActivation( "Confirm", ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )
		if self.bRegroup:
			screen.setButtonGFC( "Reset", localText.getText("TXT_KEY_SCREEN_RESET", ()), "", iX + xPanelWidth - self.iButtonWidth * 4 - self.iIncrement * 11, iY + yPanelHeight - self.iButtonHeight - self.iIncrement * 4, self.iButtonWidth, self.iButtonHeight, WidgetTypes.WIDGET_GENERAL, -1, -1, ButtonStyles.BUTTON_STYLE_STANDARD )
			screen.setActivation( "Reset", ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )
			
		screen.setImageButtonAt( "HeroPortrait", "HeroPortraitPanel", gc.getHeroInfo(self.iHero).getPortrait(), 3, 3, self.iPortraitSize, self.iPortraitSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_HERO, self.iHero, -1 )

		self.PerceivedUniquePromotions = []
		self.PerceivedMemberPromotions = []
		if pHero.getLeaderHero() == -1:
			for sUnitCombat in self.PerceivedUnitCombatLevels.keys():
				self.PerceivedUnitCombatLevels[sUnitCombat] = gc.getGame().getHeroUnitCombatLevel(self.iHero, gc.getInfoTypeForString(sUnitCombat))
			for ePromotion in range(gc.getNumPromotionInfos()):
				if gc.getGame().getHeroPromotionStatus(self.iHero, ePromotion) == 1:
					self.PerceivedUniquePromotions.append(ePromotion)
				elif gc.getGame().getHeroPromotionStatus(self.iHero, ePromotion) == 2:
					self.PerceivedMemberPromotions.append(ePromotion)
		else:
			for sUnitCombat in self.PerceivedUnitCombatLevels.keys():
				eUnitCombat = gc.getInfoTypeForString(sUnitCombat)
				if gc.getGame().getHeroUnitCombatLevel(self.iHero, eUnitCombat) < gc.getGame().getHeroUnitCombatLevel(pHero.getLeaderHero(), eUnitCombat):
					self.PerceivedUnitCombatLevels[sUnitCombat] = gc.getGame().getHeroUnitCombatLevel(self.iHero, eUnitCombat) + 1
				else:
					self.PerceivedUnitCombatLevels[sUnitCombat] = gc.getGame().getHeroUnitCombatLevel(self.iHero, eUnitCombat)
			for ePromotion in range(gc.getNumPromotionInfos()):
				if ( gc.getGame().getHeroPromotionStatus(self.iHero, ePromotion) == 1 or (gc.getGame().getHeroCoreTroop(pHero.getLeaderHero()) == self.iUnitID and gc.getGame().getHeroPromotionStatus(pHero.getLeaderHero(), ePromotion) == 1) ):
					self.PerceivedUniquePromotions.append(ePromotion)
				elif gc.getGame().getHeroPromotionStatus(self.iHero, ePromotion) == 2 or (gc.getGame().getHeroPromotionStatus(pHero.getLeaderHero(), ePromotion) == 2 and gc.getGame().getHeroCurrentNineTransformationPromotion(self.iHero) == ePromotion):
					self.PerceivedMemberPromotions.append(ePromotion) 

		self.placeStats()
		self.placeUnits()
		self.placeResult()

		return

	def placeStats(self):
		screen = self.getScreen()
		iIncrement = 4
		iTextSize = 12
		iIconSize = 24
		iX = (screen.getXResolution() - self.xPanelWidth) / 2 + self.iMargin + iIncrement
		iY = (screen.getYResolution() - self.yPanelHeight) / 2 + self.iMargin * 2 + self.iPortraitSize
		szPanel = "StatsPanel"

		pHero = gc.getPlayer(self.iPlayer).getUnit(self.iUnitID)
		
		UnitCombatEnum = {'MELEE'    :    gc.getInfoTypeForString("UNITCOMBAT_MELEE"),
				  'MOUNTED'  :    gc.getInfoTypeForString("UNITCOMBAT_MOUNTED"),
				  'ARCHER'   :    gc.getInfoTypeForString("UNITCOMBAT_ARCHER"),
				  'SIEGE'    :    gc.getInfoTypeForString("UNITCOMBAT_SIEGE"),
				  'NAVAL'    :    gc.getInfoTypeForString("UNITCOMBAT_NAVAL")}

		UnitCombatInfo = {'MELEE'    :    gc.getUnitCombatInfo(gc.getInfoTypeForString("UNITCOMBAT_MELEE")),
				  'MOUNTED'  :    gc.getUnitCombatInfo(gc.getInfoTypeForString("UNITCOMBAT_MOUNTED")),
				  'ARCHER'   :    gc.getUnitCombatInfo(gc.getInfoTypeForString("UNITCOMBAT_ARCHER")),
				  'SIEGE'    :    gc.getUnitCombatInfo(gc.getInfoTypeForString("UNITCOMBAT_SIEGE")),
				  'NAVAL'    :    gc.getUnitCombatInfo(gc.getInfoTypeForString("UNITCOMBAT_NAVAL"))}

		CombatLevelSign = {0 : '/',
				   1 : 'D',
				   2 : 'C',
				   3 : 'B',
				   4 : 'A',
				   5 : 'S'}

##>>> HoTK_JP Add Highlight Max Levels
		CurrentUnitCombatLevels = self.PerceivedUnitCombatLevels.copy()
		for sKey in CurrentUnitCombatLevels.keys():
			iUnitCombat = gc.getInfoTypeForString(sKey)
			iMaxCombatLevel = gc.getHeroInfo(pHero.getHeroType()).getPotentialUnitCombatLevel(iUnitCombat)
			iItem = CurrentUnitCombatLevels[sKey]
			if iItem == iMaxCombatLevel and iItem != 0:
				CurrentUnitCombatLevels[sKey] = u"<color=0,255,255>%s</color>" %(CombatLevelSign[iItem])
			else:
				CurrentUnitCombatLevels[sKey] = CombatLevelSign[iItem]
##<<< HoTK_JP

		screen.addPanel( szPanel, u"", u"", True, False, iX - iIncrement, iY - iIncrement, self.iPortraitSize, self.iStatsHeight, PanelStyles.PANEL_STYLE_IN )
		screen.setActivation( szPanel, ActivationTypes.ACTIVATE_MIMICPARENTFOCUS)
		screen.hide( szPanel )

		screen.setImageButtonAt( "MeleeButton", szPanel, UnitCombatInfo['MELEE'].getButton(), iIncrement, 0, iIconSize, iIconSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT_COMBAT, UnitCombatEnum['MELEE'], -1)
##>>> HoTK_JP Modified Highlight Max Levels
#		screen.setTextAt( "MeleeLevel", szPanel, CombatLevelSign[self.PerceivedUnitCombatLevels["UNITCOMBAT_MELEE"]], CvUtil.FONT_CENTER_JUSTIFY, iIncrement * 2 + iIconSize, 0, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setTextAt( "MeleeLevel", szPanel, CurrentUnitCombatLevels["UNITCOMBAT_MELEE"], CvUtil.FONT_CENTER_JUSTIFY, iIncrement * 2 + iIconSize, 0, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		screen.setImageButtonAt( "MountedButton", szPanel, UnitCombatInfo['MOUNTED'].getButton(), iIncrement * 3 + iIconSize + iTextSize, 0, iIconSize, iIconSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT_COMBAT, UnitCombatEnum['MOUNTED'], -1)
#		screen.setTextAt( "MountedLevel", szPanel, CombatLevelSign[self.PerceivedUnitCombatLevels["UNITCOMBAT_MOUNTED"]], CvUtil.FONT_CENTER_JUSTIFY, iIncrement * 4 + iIconSize * 2 + iTextSize, 0, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setTextAt( "MountedLevel", szPanel, CurrentUnitCombatLevels["UNITCOMBAT_MOUNTED"], CvUtil.FONT_CENTER_JUSTIFY, iIncrement * 4 + iIconSize * 2 + iTextSize, 0, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		screen.setImageButtonAt( "ArcherButton", szPanel, UnitCombatInfo['ARCHER'].getButton(), iIncrement * 5 + iIconSize * 2 + iTextSize * 2, 0, iIconSize, iIconSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT_COMBAT, UnitCombatEnum['ARCHER'], -1)
#		screen.setTextAt( "ArcherLevel", szPanel, CombatLevelSign[self.PerceivedUnitCombatLevels["UNITCOMBAT_ARCHER"]], CvUtil.FONT_CENTER_JUSTIFY, iIncrement * 6 + iIconSize * 3 + iTextSize * 2, 0, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setTextAt( "ArcherLevel", szPanel, CurrentUnitCombatLevels["UNITCOMBAT_ARCHER"], CvUtil.FONT_CENTER_JUSTIFY, iIncrement * 6 + iIconSize * 3 + iTextSize * 2, 0, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		screen.setImageButtonAt( "SiegeButton", szPanel, UnitCombatInfo['SIEGE'].getButton(), iIncrement * 7 + iIconSize * 3 + iTextSize * 3, 0, iIconSize, iIconSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT_COMBAT, UnitCombatEnum['SIEGE'], -1)
#		screen.setTextAt( "SiegeLevel", szPanel, CombatLevelSign[self.PerceivedUnitCombatLevels["UNITCOMBAT_SIEGE"]], CvUtil.FONT_CENTER_JUSTIFY, iIncrement * 8 + iIconSize * 4 + iTextSize * 3, 0, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setTextAt( "SiegeLevel", szPanel, CurrentUnitCombatLevels["UNITCOMBAT_SIEGE"], CvUtil.FONT_CENTER_JUSTIFY, iIncrement * 8 + iIconSize * 4 + iTextSize * 3, 0, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		screen.setImageButtonAt( "NavalButton", szPanel, UnitCombatInfo['NAVAL'].getButton(), iIncrement * 9 + iIconSize * 4 + iTextSize * 4, 0, iIconSize, iIconSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT_COMBAT, UnitCombatEnum['NAVAL'], -1)
#		screen.setTextAt( "NavalLevel", szPanel, CombatLevelSign[self.PerceivedUnitCombatLevels["UNITCOMBAT_NAVAL"]], CvUtil.FONT_CENTER_JUSTIFY, iIncrement * 10 + iIconSize * 5 + iTextSize * 4, 0, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setTextAt( "NavalLevel", szPanel, CurrentUnitCombatLevels["UNITCOMBAT_NAVAL"], CvUtil.FONT_CENTER_JUSTIFY, iIncrement * 10 + iIconSize * 5 + iTextSize * 4, 0, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
##<<< HoTK_JP

		screen.setTextAt( "UniquePromotionHeader", szPanel, u"%c" % CyGame().getSymbolID(FontSymbols.STAR_CHAR), CvUtil.FONT_LEFT_JUSTIFY, iIncrement, iIconSize + iIncrement, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		screen.addMultiListControlGFCAt( szPanel, "UniquePromotions", "", iIncrement * 2 + iIconSize, iIconSize + iIncrement, iIconSize * 8, iIconSize, 1, iIconSize, iIconSize, TableStyles.TABLE_STYLE_STANDARD )		
		screen.hide( "UniquePromotions" )

		screen.setTextAt( "MemberPromotionHeader", szPanel, u"%c" % CyGame().getSymbolID(FontSymbols.SILVER_STAR_CHAR), CvUtil.FONT_LEFT_JUSTIFY, iIncrement, iIconSize * 2+ iIncrement * 2, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		screen.addMultiListControlGFCAt(szPanel, "MemberPromotions", "", iIncrement * 2 + iIconSize, iIconSize * 2 + iIncrement * 2, iIconSize * 8, iIconSize, 1, iIconSize, iIconSize, TableStyles.TABLE_STYLE_STANDARD )		
		screen.hide( "MemberPromotions" )

		for ePromotion in self.PerceivedUniquePromotions:
			szButton = gc.getPromotionInfo(ePromotion).getButton()
			screen.appendMultiListButton( "UniquePromotions", szButton, 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_PROMOTION, ePromotion, -1, False )
			screen.show( "UniquePromotions" )
		for ePromotion in self.PerceivedMemberPromotions:
			szButton = gc.getPromotionInfo(ePromotion).getButton()
			screen.appendMultiListButton( "MemberPromotions", szButton, 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_PROMOTION, ePromotion, -1, False )
			screen.show( "MemberPromotions" )

##HoTK_JP TextAdjust START  by yos
		#szTempBuffer = localText.getText("INTERFACE_PANE_LEVEL", ()) + " " + u"%d" % (gc.getGame().getHeroLevel(self.iHero))
		szTempBuffer = localText.getText("INTERFACE_PANE_LEVEL", ()) + " " + u"%d" % (gc.getGame().getHeroLevel(self.iHero))
		szTempBuffer += " " + localText.getText("INTERFACE_PANE_EXPERIENCE", ()) + ": " + u"%d/%d" % (int(gc.getGame().getHeroExperience(self.iHero)), gc.getGame().heroExperienceNeeded(self.iHero))
		szTempBuffer += " " + localText.getText("INTERFACE_PANE_CAPACITY", ()) + ": " + u"%d" % (gc.getGame().getHeroCapacity(self.iHero, False, -1))
		szTempBuffer = localText.changeTextColor(szTempBuffer, gc.getInfoTypeForString("COLOR_UNIT_TEXT"))
		screen.setTextAt( "HeroLevel", szPanel, szTempBuffer, CvUtil.FONT_LEFT_JUSTIFY, iIncrement, iIconSize * 3+ iIncrement * 3, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		#szTempBuffer = localText.getText("INTERFACE_PANE_EXPERIENCE", ()) + ": " + u"%d/%d" % (int(gc.getGame().getHeroExperience(self.iHero)), gc.getGame().heroExperienceNeeded(self.iHero))
		#szTempBuffer = localText.changeTextColor(szTempBuffer, gc.getInfoTypeForString("COLOR_UNIT_TEXT"))
		#screen.setTextAt( "HeroExperience", szPanel, szTempBuffer, CvUtil.FONT_LEFT_JUSTIFY, iIncrement * 3 + iIconSize * 2, iIconSize * 3+ iIncrement * 3, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)

		#szTempBuffer = localText.getText("INTERFACE_PANE_CAPACITY", ()) + ": " + u"%d" % (gc.getGame().getHeroCapacity(self.iHero, False, -1))
		#szTempBuffer = localText.changeTextColor(szTempBuffer, gc.getInfoTypeForString("COLOR_UNIT_TEXT"))
		#screen.setTextAt( "HeroCapacity", szPanel, szTempBuffer, CvUtil.FONT_LEFT_JUSTIFY, iIncrement * 5 + iIconSize * 5, iIconSize * 3+ iIncrement * 3, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
##HoTK_JP TextAdjust END

		screen.show( szPanel )

	def placeUnits(self):
		screen = self.getScreen()
		
		iIncrement = self.iIncrement
		iTextSize = 64
		iIconSize = 24
		iButtonSize = 48
		iX = (screen.getXResolution() - self.xPanelWidth) / 2 + self.iMargin * 2 + self.iPortraitSize
		iY = (screen.getYResolution() - self.yPanelHeight) / 2 + self.iMargin * 2 + 64
		iWidth = self.xPanelWidth - self.iMargin * 3 - self.iPortraitSize + self.iIncrement * 2
		iHeight = self.yPanelHeight - self.iMargin * 3 - iTextSize - iButtonSize - self.iIncrement * 2
		iRowHeight = 64
		szPanel = "MemberUnitPanel"

		screen.addScrollPanel( szPanel, u"", iX, iY, iWidth, iHeight, PanelStyles.PANEL_STYLE_EXTERNAL )
		screen.setActivation( szPanel, ActivationTypes.ACTIVATE_NORMAL )

		pHero = gc.getPlayer(self.iPlayer).getUnit(self.iUnitID)
		pPlot = pHero.plot()
		iCount = 0
		CyInterface().cacheInterfacePlotUnits(pPlot)
		UnitList = []
		
		for i in range(CyInterface().getNumCachedInterfacePlotUnits()):
			pLoopUnit = CyInterface().getCachedInterfacePlotUnit(i)
			if (pLoopUnit):
				if (pLoopUnit.getOwner() == gc.getGame().getActivePlayer()
				    and pLoopUnit.getUnitCombatType() != -1
				    and pLoopUnit.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_HERO")
				    and pLoopUnit.getUnitCombatType() != gc.getInfoTypeForString("UNITCOMBAT_RECON")
				    and ( pLoopUnit.getLegionHero() == -1 or pLoopUnit.getLegionHero() == self.iHero ) ):
					UnitList.append(pLoopUnit.getID())

		for iUnitID in self.InitNotSamePlotMemberList:
			UnitList.append(iUnitID)

		for iID in UnitList:
			pLoopUnit = gc.getPlayer(self.iPlayer).getUnit(iID)

			# Add units that can potentiall be the core troop to the core troop check list
			if ( pLoopUnit.getLeaderUnitType() == -1  or ( pLoopUnit.getLeaderUnitType() != -1 and pLoopUnit.getHeroType() != -1 ) ):
				self.LegionCoreTroopCheck[iID] = 0

			# Add all units to the member check list for they can all potentially be a member
			self.LegionMemberCheck[iID] = 0

			# put the unit's id to its UnitCombat Dict for later use
			if not iID in self.CombatUnitDict[gc.getUnitCombatInfo(pLoopUnit.getUnitCombatType()).getType()]: 
				self.CombatUnitDict[gc.getUnitCombatInfo(pLoopUnit.getUnitCombatType()).getType()].append(iID)

			# Add Member Unit Row
			szUnitRow = "UnitRow" + str(iID)
			screen.attachPanelAt( szPanel, szUnitRow, "", "", True, False, PanelStyles.PANEL_STYLE_STANDARD, 0, iRowHeight * iCount, iWidth - iIncrement * 8, iRowHeight, WidgetTypes.WIDGET_GENERAL, -1, -1 )
			screen.setActivation( szUnitRow, ActivationTypes.ACTIVATE_MIMICPARENTFOCUS)
			screen.hide( szUnitRow )

			# Core Troop Check Box
			if self.LegionCoreTroopCheck.has_key(iID):
				control = "CoreTroopCheck" + str(iID)
				screen.addCheckBoxGFCAt( szUnitRow, control, ArtFileMgr.getInterfaceArtInfo("INTERFACE_GLOBE_TOGGLE_HILIGHT").getPath(), ArtFileMgr.getInterfaceArtInfo("HERO_CORE_TROOP").getPath(), iIncrement, iIncrement, iIconSize, iIconSize, WidgetTypes.WIDGET_CHECK_CORE_TROOP, iID, self.iHero, ButtonStyles.BUTTON_STYLE_LABEL, False )
				if iID in self.InitLegionMemberList:
					if self.InitLegionMemberList[0] == iID:
						screen.setState( control, True )
						self.LegionCoreTroopCheck[iID] = 1
					if ( iID in self.InitNotSamePlotMemberList ) or ( iID in self.InitHasMovedMemberList ):
						screen.enable( control, False )
				elif len(self.InitLegionMemberList) > 0:
					if pLoopUnit.getUnitCombatType() != gc.getPlayer(pHero.getOwner()).getUnit(self.InitLegionMemberList[0]).getUnitCombatType():
						screen.enable( control, False )
					elif len(self.InitLegionMemberList) == gc.getGame().getHeroCapacity(self.iHero, False, -1):
						screen.enable( control, False )
				if pHero.getLegionHero() != HeroTypes.NO_HERO and (pHero.isHurt() or pHero.hasMoved()):
					screen.enable( control, False)
					
			# Member Check Box --- Unit Button, temporarily disable it if it's a Warlord and there's currently no Legion Member
			control = "UnitButton" + str(iID)
			screen.addCheckBoxGFCAt( szUnitRow, control, gc.getUnitInfo(pLoopUnit.getUnitType()).getButton(), ArtFileMgr.getInterfaceArtInfo("BUTTON_HILITE_SQUARE").getPath(), iIncrement * 2 + iIconSize, iIncrement, iButtonSize, iButtonSize, WidgetTypes.WIDGET_CHECK_MEMBER_TROOP, iID, self.iHero, ButtonStyles.BUTTON_STYLE_LABEL, False )
			if iID in self.InitLegionMemberList:
				screen.setState( control, True )
				self.LegionMemberCheck[iID] = 1
				if ( iID in self.InitNotSamePlotMemberList ) or ( iID in self.InitHasMovedMemberList ):
					screen.enable( control, False )
			elif len(self.InitLegionMemberList) == 0:
				if not self.LegionCoreTroopCheck.has_key(iID):
					screen.enable ( control, False )
			elif len(self.InitLegionMemberList) > 0:
				if pLoopUnit.getUnitCombatType() != gc.getPlayer(pHero.getOwner()).getUnit(self.InitLegionMemberList[0]).getUnitCombatType():
					screen.enable( control, False )
				elif len(self.InitLegionMemberList) == gc.getGame().getHeroCapacity(self.iHero, False, -1):
					screen.enable( control, False )
				elif not self.LegionCoreTroopCheck.has_key(iID):
					screen.enable ( control, True )
					 
			# Unit Stats: Level and XP
			control = "UnitLevel" + str(iID)
			szText = BugUtil.getPlainText("TXT_KEY_HERO_LEVEL") + ": " + "%d" % (pLoopUnit.getLevel())
			screen.setTextAt( control, szUnitRow, szText, CvUtil.FONT_LEFT_JUSTIFY, iIncrement * 3 + iIconSize + iButtonSize, iIncrement, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
			screen.setActivation( control, ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )

			control = "UnitXP" + str(iID)
			szText = BugUtil.getPlainText("TXT_KEY_HERO_XP") + ": " + "%d" % (pLoopUnit.getExperience()) + "/" + "%d" % (pLoopUnit.experienceNeeded())
			screen.setTextAt( control, szUnitRow, szText, CvUtil.FONT_LEFT_JUSTIFY, iIncrement * 3 + iIconSize + iButtonSize, iIncrement + 24, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
			screen.setActivation( control, ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )

			# Unit Stats: Strength and Movement
			control = "UnitStr" + str(iID)
			szText = u"%c" % CyGame().getSymbolID(FontSymbols.STRENGTH_CHAR) + " " + "%d" % (((float)(pLoopUnit.baseCombatStr() * pLoopUnit.currHitPoints())) / ((float)(pLoopUnit.maxHitPoints()))) + "/" + "%d" % (pLoopUnit.baseCombatStr())
			screen.setTextAt( control, szUnitRow, szText, CvUtil.FONT_LEFT_JUSTIFY, iIncrement * 4 + iIconSize + iButtonSize + iTextSize, iIncrement, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
			screen.setActivation( control, ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )

			control = "UnitMove" + str(iID)
			if pLoopUnit.movesLeft() % gc.getMOVE_DENOMINATOR() > 0:
				iTempBuffer = 1
			else:
				iTempBuffer = 0
			iCurrMoves = ( pLoopUnit.movesLeft() / gc.getMOVE_DENOMINATOR() ) + iTempBuffer
			szText = u"%c" % CyGame().getSymbolID(FontSymbols.MOVES_CHAR) + " " + "%d" % (iCurrMoves) + "/" + "%d" % (pLoopUnit.baseMoves())
			screen.setTextAt( control, szUnitRow, szText, CvUtil.FONT_LEFT_JUSTIFY, iIncrement * 4 + iIconSize + iButtonSize + iTextSize, iIncrement + 24, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
			screen.setActivation( control, ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )
			
			# Unit Promotions
			control = "UnitPromotions" + str(iID)
			screen.addMultiListControlGFCAt( szUnitRow, control, "Unit Promotions", iIncrement * 5 + iIconSize + iButtonSize + iTextSize * 2, iIncrement, iButtonSize * 6, iButtonSize, 1, iButtonSize, iButtonSize, TableStyles.TABLE_STYLE_STANDARD )
			screen.hide( control )

			for j in range (gc.getNumPromotionInfos()):
				if ( pLoopUnit.isHasPromotion(j) ):
					if ( gc.getGame().getHeroCurrentNineTransformationPromotion(self.iHero) == j and self.LegionMemberCheck[iID] == 0):
						continue
					szButton = gc.getPromotionInfo(j).getButton()
					screen.appendMultiListButton( control, szButton, 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_PROMOTION, j, -1, False )
					screen.show( control )
				elif ( gc.getGame().isHeroHasLegionMember(self.iHero, iID) ):
					if ( gc.getPromotionInfo(j).getPromotionUnitCombatType() == pLoopUnit.getUnitCombatType()):
						if ( gc.getPromotionInfo(j).getPromotionUnitCombatLevel() == self.PerceivedUnitCombatLevels[gc.getUnitCombatInfo(pLoopUnit.getUnitCombatType()).getType()] ):
							szButton = gc.getPromotionInfo(j).getButton()
							screen.appendMultiListButton( control, szButton, 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_PROMOTION, j, -1, False )
							screen.show( control )
					elif ( j in self.PerceivedUniquePromotions ):
						if ( gc.getGame().getHeroCoreTroop(self.iHero) == iID ):
							szButton = gc.getPromotionInfo(j).getButton()
							screen.appendMultiListButton( control, szButton, 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_PROMOTION, j, -1, False )
							screen.show( control )
					elif ( j in self.PerceivedMemberPromotions ):
						szButton = gc.getPromotionInfo(j).getButton()
						screen.appendMultiListButton( control, szButton, 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_PROMOTION, j, -1, False )
						screen.show( control )

			iCount += 1

			screen.show( szUnitRow )

	# Place the selected core troop and member units on the top right
	def placeResult(self):
		screen = self.getScreen()

		iIncrement = 4
		iTextSize = 64
		iIconSize = 24
		iButtonSize = 48
		iX = (screen.getXResolution() - self.xPanelWidth) / 2 + self.iMargin * 2 + self.iPortraitSize
		iY = (screen.getYResolution() - self.yPanelHeight) / 2 + self.iMargin * 2
		iWidth = self.xPanelWidth - self.iMargin * 3 - self.iPortraitSize
		iHeight = 64
		szPanel = "ResultPanel"

		screen.addScrollPanel( szPanel, u"", iX, iY, iWidth, iHeight, PanelStyles.PANEL_STYLE_EXTERNAL )
		screen.setActivation( szPanel, ActivationTypes.ACTIVATE_NORMAL )

		szResultRow = "ResultRow"
		screen.attachPanelAt( szPanel, szResultRow, "", "", True, False, PanelStyles.PANEL_STYLE_IN, 0, 0, iWidth - iIncrement * 6, iHeight, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		screen.setActivation( szResultRow, ActivationTypes.ACTIVATE_MIMICPARENTFOCUS)
		screen.hide( szResultRow )

		# Place Golden Star to Denote Core Troop
		control = "CoreTroopStar"
		szText = u"%c" % CyGame().getSymbolID(FontSymbols.STAR_CHAR)
		screen.setTextAt( control, szResultRow, szText, CvUtil.FONT_CENTER_JUSTIFY, iIncrement, iIncrement, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setActivation( control, ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )

		if ( gc.getGame().getHeroLegionSize(self.iHero) > 0 ):
			iUnitID = gc.getGame().getHeroCoreTroop(self.iHero)
			pUnit = gc.getPlayer(self.iPlayer).getUnit(iUnitID)
			if pUnit:
				# Place Core Troop Button
				control = "CoreTroopButton"
				screen.setImageButtonAt( control, szResultRow, gc.getUnitInfo(pUnit.getUnitType()).getButton(), iIncrement * 2 + 16, iIncrement, iButtonSize, iButtonSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT, pUnit.getUnitType(), -1 )

		# Place Silver Star to Denote Member Units
		control = "MemberUnitStar"
		szText = u"%c" % CyGame().getSymbolID(FontSymbols.SILVER_STAR_CHAR)
		screen.setTextAt( control, szResultRow, szText, CvUtil.FONT_CENTER_JUSTIFY, iIncrement * 4 + 16 + iButtonSize, iIncrement, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
		screen.setActivation( control, ActivationTypes.ACTIVATE_MIMICPARENTFOCUS )

		# Place Member Unit Buttons
		control = "MemberUnitList"
		screen.addMultiListControlGFCAt( szResultRow, control, "", iIncrement * 5 + iIconSize * 2 + iButtonSize, 0, iButtonSize * 8 + 4, iButtonSize, 1, iButtonSize, iButtonSize, TableStyles.TABLE_STYLE_STANDARD )
		screen.hide( control )

		if ( gc.getGame().getHeroLegionSize(self.iHero) > 1):
			for iIndex in range(1, gc.getGame().getHeroLegionSize(self.iHero)):
				iUnitID = gc.getGame().getHeroLegionMemberAt(self.iHero, iIndex)
				pUnit = gc.getPlayer(self.iPlayer).getUnit(iUnitID)
				if pUnit:
					szButton = gc.getUnitInfo(pUnit.getUnitType()).getButton()
					screen.appendMultiListButton( control, szButton, 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT, pUnit.getUnitType(), -1, False )
					screen.show( control )

		screen.show( szResultRow )


	# Will update the member units panel
	def updateUnits (self, iUnitID, bEnableWarlord, bDisableWarlord, bEnableUnitCombat, bDisableUnitCombat):
		screen = self.getScreen()

		if iUnitID != -1:
			pUnit = gc.getPlayer(self.iPlayer).getUnit(iUnitID)
			if pUnit:
				control = "UnitPromotions" + str(iUnitID)
				screen.clearMultiList( control )
				screen.hide( control )

				for j in range (gc.getNumPromotionInfos()):
					if ( pUnit.isHasPromotion(j) ):
						if ( gc.getGame().getHeroCurrentNineTransformationPromotion(self.iHero) == j and self.LegionMemberCheck[iUnitID] == 0):
							continue
						if not ( (j in self.PerceivedUniquePromotions) and self.LegionCoreTroopCheck.get(iUnitID) == 0):
							if not ( self.LegionMemberCheck.get(iUnitID) == 0 and (gc.getPromotionInfo(j).getPromotionUnitCombatType() == pUnit.getUnitCombatType() or (j in self.PerceivedMemberPromotions)) ):
								szButton = gc.getPromotionInfo(j).getButton()
								screen.appendMultiListButton( control, szButton, 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_PROMOTION, j, -1, False )
								screen.show( control )
					elif ( self.LegionMemberCheck.get(iUnitID) == 1 ):
						if ( gc.getPromotionInfo(j).getPromotionUnitCombatType() == pUnit.getUnitCombatType()):
							if ( gc.getPromotionInfo(j).getPromotionUnitCombatLevel() == self.PerceivedUnitCombatLevels[gc.getUnitCombatInfo(pUnit.getUnitCombatType()).getType()] ):
								szButton = gc.getPromotionInfo(j).getButton()
								screen.appendMultiListButton( control, szButton, 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_PROMOTION, j, -1, False )
								screen.show( control )
						elif ( j in self.PerceivedUniquePromotions ):
							if ( self.LegionCoreTroopCheck.get(iUnitID) == 1 ):
								szButton = gc.getPromotionInfo(j).getButton()
								screen.appendMultiListButton( control, szButton, 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_PROMOTION, j, -1, False )
								screen.show( control )
						elif ( j in self.PerceivedMemberPromotions ):
							szButton = gc.getPromotionInfo(j).getButton()
							screen.appendMultiListButton( control, szButton, 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_PROMOTION, j, -1, False )
							screen.show( control )

				screen.show( control )
				
				eUnitCombat = pUnit.getUnitCombatType()
				if bEnableUnitCombat:
					
					# Check to see if there's still a core troop left in the legion
					bHasCore = False
					for iLoopID in self.LegionCoreTroopCheck.keys():
						if self.LegionCoreTroopCheck.get(iLoopID) == 1:
							bHasCore = True

					pHero = gc.getPlayer(self.iPlayer).getUnit(self.iUnitID)

					# Enable units with the same unitCombat as the passed unit
					for iLoopID in self.CombatUnitDict[gc.getUnitCombatInfo(eUnitCombat).getType()]:
						if ( iLoopID not in self.InitNotSamePlotMemberList ) and ( iLoopID not in self.InitHasMovedMemberList ):
							pLoopUnit = gc.getPlayer(self.iPlayer).getUnit(iLoopID)
							if ( pLoopUnit.getLeaderUnitType() != -1
							     and pLoopUnit.getHeroType() == -1
							     ):
								if bHasCore:
									control = "UnitButton" + str(iLoopID)
									screen.enable( control, True )
							else:
								if pHero.getLegionHero() != HeroTypes.NO_HERO and not pHero.isHurt():
									control = "CoreTroopCheck" + str(iLoopID)
									screen.enable( control, True )
								control = "UnitButton" + str(iLoopID)
								screen.enable( control, True )

					# Enable units with different unitCombat as the passed unit if necessary
					if not bHasCore:
						for iLoopID in self.LegionMemberCheck.keys():
							pLoopUnit = gc.getPlayer(self.iPlayer).getUnit(iLoopID)
							if pLoopUnit.getUnitCombatType() != eUnitCombat:
								control = "UnitButton" + str(iLoopID)
								screen.enable( control, True )
								if self.LegionCoreTroopCheck.has_key(iLoopID):
									control = "CoreTroopCheck" + str(iLoopID)
									screen.enable( control, True )
				elif bDisableUnitCombat:

					# Disable units whose unitcombat is different with the passed unit
					for iLoopID in self.LegionMemberCheck.keys():
						pLoopUnit = gc.getPlayer(self.iPlayer).getUnit(iLoopID)
						if pLoopUnit.getUnitCombatType() != eUnitCombat:
							control = "UnitButton" + str(iLoopID)
							screen.enable( control, False )
							if self.LegionCoreTroopCheck.has_key(iLoopID):
								control = "CoreTroopCheck" + str(iLoopID)
								screen.enable( control, False )
								
					# Disable units with the same unitCombat as the passed unit if their number checked exceeds the hero's level           
					EnabledUnitList = []
					for iLoopID in self.CombatUnitDict[gc.getUnitCombatInfo(eUnitCombat).getType()]:
						if self.LegionMemberCheck.get(iLoopID) == 1:
							EnabledUnitList.append(iLoopID)
					if len(EnabledUnitList) >= gc.getGame().getHeroCapacity(self.iHero, False, -1):
						for iLoopID in self.CombatUnitDict[gc.getUnitCombatInfo(eUnitCombat).getType()]:
							if self.LegionMemberCheck.get(iLoopID) == 0:
								control = "UnitButton" + str(iLoopID)
								screen.enable( control, False )
								if self.LegionCoreTroopCheck.get(iLoopID) == 0:
									control = "CoreTroopCheck" + str(iLoopID)
									screen.enable( control, False )

		if bEnableWarlord:
			for iLoopID in self.LegionMemberCheck.keys():
				if ( iLoopID not in self.InitNotSamePlotMemberList ) and ( iLoopID not in self.InitHasMovedMemberList ):
					pUnit =  gc.getPlayer(self.iPlayer).getUnit(iLoopID)
					if ( pUnit.getLeaderUnitType() != -1
					     and pUnit.getHeroType() == -1
					     ):
						eUnitCombat = pUnit.getUnitCombatType()
						EnabledUnitList = []
						for iLoopLoopID in self.CombatUnitDict[gc.getUnitCombatInfo(eUnitCombat).getType()]:
							if self.LegionMemberCheck.get(iLoopLoopID) == 1:
								EnabledUnitList.append(iLoopLoopID)
						if ( len(EnabledUnitList) < gc.getGame().getHeroCapacity(self.iHero, False, -1) and eUnitCombat == gc.getPlayer(pHero.getOwner()).getUnit(iUnitID).getUnitCombatType() ):
							control = "UnitButton" + str(iLoopID)
							screen.enable ( control, True )
		elif bDisableWarlord:
			for iLoopID in self.LegionMemberCheck.keys():
				pUnit =  gc.getPlayer(self.iPlayer).getUnit(iLoopID)
				if ( pUnit.getLeaderUnitType() != -1
				     and pUnit.getHeroType() == -1
				     ):
					control = "UnitButton" + str(iLoopID)
					screen.enable ( control, False )


	# Will update the legion result panel
	def updateResult(self, bCoreTroop, bMemberTroop):
		screen = self.getScreen()

		iButtonSize = 48
		iIconSize = 24
		iIncrement = 4

		if bCoreTroop:
			bHasCore = False
			control = "CoreTroopButton"
			screen.deleteWidget( control )
			for iUnitID in self.LegionCoreTroopCheck.keys():
				if self.LegionCoreTroopCheck[iUnitID] == 1:
					pUnit = gc.getPlayer(self.iPlayer).getUnit(iUnitID)
					if pUnit:
						screen.setImageButtonAt( control, "ResultPanel", gc.getUnitInfo(pUnit.getUnitType()).getButton(), iIncrement * 2 + iIconSize, iIncrement * 2 - 1, iButtonSize, iButtonSize, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT, pUnit.getUnitType(), -1 )
						bHasCore = True
			if not bHasCore:
				screen.addDDSGFCAt( control, "ResultPanel", "", iIncrement * 2 + iIconSize, iIncrement * 2 - 1, iButtonSize, iButtonSize, WidgetTypes.WIDGET_GENERAL, -1, -1, False )
				screen.hide( control )

		if bMemberTroop:
			control = "MemberUnitList"
			screen.clearMultiList( control )
			screen.hide( control )
			
			for iUnitID in self.LegionMemberCheck.keys():
				if self.LegionMemberCheck[iUnitID] == 1:
					pUnit = gc.getPlayer(self.iPlayer).getUnit(iUnitID)
					if pUnit and self.LegionCoreTroopCheck.get(iUnitID) != 1:
						szButton = gc.getUnitInfo(pUnit.getUnitType()).getButton()
						screen.appendMultiListButton( control, szButton, 0, WidgetTypes.WIDGET_PEDIA_JUMP_TO_UNIT, pUnit.getUnitType(), -1, False )
						screen.show( control )


	# Will show the unit model and help text for the mouse-overed UnitButton checkbox
	def updateHelp (self, inputClass):
		screen = self.getScreen()

##                screen.addPanel( "UnitHelpPanel", u"", u"", True, True, iX + iMargin, iY + iMargin * 3 + 300, self.iPortraitSize, yPanelHeight - 330 - iMargin * 4, PanelStyles.PANEL_STYLE_IN )
		iX = (screen.getXResolution() - self.xPanelWidth) / 2 + self.iMargin
		iY = (screen.getYResolution() - self.yPanelHeight) / 2 + self.iMargin * 2 + self.iPortraitSize + self.iStatsHeight
		iWidth = self.iPortraitSize
		iHeight = self.yPanelHeight - self.iPortraitSize - self.iStatsHeight - self.iMargin * 5
		iIncrement = self.iIncrement

		if ( inputClass.getNotifyCode() == NotifyCode.NOTIFY_CURSOR_MOVE_ON ):
			pUnit = gc.getPlayer(self.iPlayer).getUnit(inputClass.getID())
			eUnitType = pUnit.getUnitType()
			
			control = "UnitGraphic"
			screen.addUnitGraphicGFC( control, eUnitType, iX + iIncrement, iY + iIncrement, iWidth, iHeight, WidgetTypes.WIDGET_GENERAL, -1, -1, -20, 30, 1.0, False)

			szSpecialText = pUnit.getName()
			control = "HelpText"
			screen.setTextAt( control, "UnitGraphic", szSpecialText, CvUtil.FONT_LEFT_JUSTIFY, 0, 0, -0.1, FontTypes.GAME_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1)
			screen.moveToFront( control )
			
		elif ( inputClass.getNotifyCode() == NotifyCode.NOTIFY_CURSOR_MOVE_OFF ):

			screen.deleteWidget( "HelpText" )
			screen.deleteWidget( "UnitGraphic" )


	# Will clear screen selection as well as empty the Hero's LegionMemberList; If it's regrouping mission, reset to initial status
	def resetSelection (self, bEmpty):
		screen = self.getScreen()
		
		if bEmpty:                
			for key in self.LegionCoreTroopCheck.keys():
				self.LegionCoreTroopCheck[key] = 0
				control = "CoreTroopCheck" + str(key)
				screen.setState( control, False)
				if not key in self.InitNotSamePlotMemberList:
					screen.enable( control, True )
			for key in self.LegionMemberCheck.keys():
				self.LegionMemberCheck[key] = 0
				control = "UnitButton" + str(key)
				screen.setState( control, False)
				if not key in self.InitNotSamePlotMemberList:
					screen.enable( control, True )

				if gc.getPlayer(self.iPlayer).getUnit(key).getLeaderUnitType() != -1:
					screen.enable( control, False )

				self.updateUnits( key, False, False, False, False )
				
			self.updateResult( True, True )

			CyMessageControl().sendModNetMessage(12, self.iHero, -1, -1, -1)
		else:
			CyMessageControl().sendModNetMessage(12, self.iHero, -1, -1, -1)

			for iUnitID in self.InitLegionMemberList:
				CyMessageControl().sendModNetMessage(4, iUnitID, self.iHero, 0, -1)

			self.placeUnits()
			self.updateResult( True, True )


	# Will handle the input for this screen...
	def handleInput (self, inputClass):
		# Get the screen
		screen = self.getScreen()

		szWidgetName = inputClass.getFunctionName() + str(inputClass.getID())

		if ( inputClass.getFunctionName() == "Clear" ):
			self.resetSelection(True)
			return 1

		if ( inputClass.getFunctionName() == "Cancel" ):
			if self.bRegroup:
				self.resetSelection(False)
			else:
				self.resetSelection(True)
			return 1

		if ( inputClass.getFunctionName() == "Reset" ):
			self.resetSelection(False)
			return 1

		if ( inputClass.getButtonType() == WidgetTypes.WIDGET_FORM_LEGION ):
			screen.hideScreen()
			return 1
		
		if ( inputClass.getNotifyCode() == NotifyCode.NOTIFY_CLICKED ):
			if ( inputClass.getButtonType() == WidgetTypes.WIDGET_CHECK_CORE_TROOP ):
				
				if ( self.LegionCoreTroopCheck.get( inputClass.getData1() ) == 0 ):

					# If there's already another unit as Core Troop, uncheck it, and then check this unit as Core
					for iUnitID in self.LegionCoreTroopCheck.keys():
						if self.LegionCoreTroopCheck[iUnitID] == 1:
							self.LegionCoreTroopCheck[iUnitID] = 0
							szName = "CoreTroopCheck" + str(iUnitID)
							screen.setState( szName, False )
							self.updateUnits( iUnitID, False, False, False, False )
							
					self.LegionCoreTroopCheck[inputClass.getData1()] = 1
					self.updateUnits( inputClass.getData1(), True, False, False, False )
					self.updateResult( True, True )

					# If this unit is new to the legion, check the Member Status as well
					if self.LegionMemberCheck[inputClass.getData1()] == 0:
						self.LegionMemberCheck[inputClass.getData1()] = 1
						szName = "UnitButton" + str(inputClass.getData1())
						screen.setState( szName, True )
						self.updateUnits( inputClass.getData1(), False, False, False, True )
						self.updateResult( False, True )
					
				elif ( self.LegionCoreTroopCheck.get( inputClass.getData1() ) == 1 ):

					# Set the unit's Core Troop Status and Member Status to False since It's no longer in the legion
					self.LegionCoreTroopCheck[inputClass.getData1()] = 0
					self.LegionMemberCheck[inputClass.getData1()] = 0
					szName = "UnitButton" + str(inputClass.getData1())
					screen.setState( szName, False )
					self.updateUnits( inputClass.getData1(), False, True, True, False )
					self.updateResult( True, False )
					
					# Assign the first unit that remains in the legion as Core Troop, provided that remaining one isn't a warlord
					if gc.getGame().getHeroLegionSize(self.iHero) > 1:
						iUnitID = gc.getGame().getHeroLegionMemberAt(self.iHero, 1)
						if iUnitID != -1:
							if gc.getPlayer(self.iPlayer).getUnit(iUnitID).getLeaderUnitType() == -1:
								self.LegionCoreTroopCheck[iUnitID] = 1
								szName = "CoreTroopCheck" + str(iUnitID)
								screen.setState( szName, True )
								self.updateUnits( iUnitID, True, False, False, True )
								self.updateResult( True, True )
							else:
								# kick all remaining warlord unit(s) out of the legion...
								WarlordList = []
								for iIndex in range(1, gc.getGame().getHeroLegionSize(self.iHero)):
									WarlordList.append(gc.getGame().getHeroLegionMemberAt(self.iHero, iIndex))
								for iWarlordID in WarlordList:
									gc.getGame().deleteHeroLegionMember(self.iHero, iWarlordID)
									self.LegionMemberCheck[iWarlordID] = 0
									szName = "UnitButton" + str(iWarlordID)
									screen.setState( szName, False )
									self.updateUnits( iWarlordID, False, True, True, False )
									self.updateResult( False, True )
					
				return 1

			elif ( inputClass.getButtonType() == WidgetTypes.WIDGET_CHECK_MEMBER_TROOP ):

				if ( self.LegionMemberCheck.get( inputClass.getData1() ) == 0 ):

					# Check this unit's member status
					self.LegionMemberCheck[inputClass.getData1()] = 1
					self.updateUnits( inputClass.getData1(), False, False, False, True )
					self.updateResult( False, True )

					# If this unit is the only one in the Legion, set it as the Core Troop
					if ( gc.getGame().getHeroLegionSize(self.iHero) == 0 and self.LegionCoreTroopCheck.has_key(inputClass.getData1()) ):
						self.LegionCoreTroopCheck[inputClass.getData1()] = 1
						szName = "CoreTroopCheck" + str(inputClass.getData1())
						screen.setState( szName, True )
						self.updateUnits( inputClass.getData1(), True, False, False, False )
						self.updateResult( True, True )
						
				elif ( self.LegionMemberCheck.get( inputClass.getData1() ) == 1 ):

					# Uncheck this unit's member status
					self.LegionMemberCheck[inputClass.getData1()] = 0
					self.updateUnits( inputClass.getData1(), False, False, True, False )
					self.updateResult( False, True )
					
					# If this unit is previously set as Core Troop, uncheck it
					if self.LegionCoreTroopCheck.get( inputClass.getData1() ) == 1:
						self.LegionCoreTroopCheck[inputClass.getData1()] = 0
						szName = "CoreTroopCheck" + str(inputClass.getData1())
						screen.setState( szName, False )
						self.updateUnits( inputClass.getData1(), False, True, True, False )
						self.updateResult( True, False )

						# If there's at least another non-warlord unit in the legion, find a new Core Troop
						if gc.getGame().getHeroLegionSize(self.iHero) > 1:
							iUnitID = gc.getGame().getHeroLegionMemberAt(self.iHero, 1)
							if iUnitID != -1:
								if gc.getPlayer(self.iPlayer).getUnit(iUnitID).getLeaderUnitType() == -1:
									self.LegionCoreTroopCheck[iUnitID] = 1
									szName = "CoreTroopCheck" + str(iUnitID)
									screen.setState( szName, True )
									self.updateUnits( iUnitID, True, False, False, True )
									self.updateResult( True, True )
								else:
									# kick all remaining warlord unit(s) out of the legion...
									WarlordList = []
									for iIndex in range(1, gc.getGame().getHeroLegionSize(self.iHero)):
										WarlordList.append(gc.getGame().getHeroLegionMemberAt(self.iHero, iIndex))
									for iWarlordID in WarlordList:
										gc.getGame().deleteHeroLegionMember(self.iHero, iWarlordID)
										self.LegionMemberCheck[iWarlordID] = 0
										szName = "UnitButton" + str(iWarlordID)
										screen.setState( szName, False )
										self.updateUnits( iWarlordID, False, True, True, False )
										self.updateResult( False, True )
				return 1

		if ( inputClass.getFunctionName() == "CoreTroopCheck" or inputClass.getFunctionName() == "UnitButton" ):
			self.updateHelp(inputClass)
			return 1
		
		return 0

	def getNextWidgetName(self, sName):
		szName = sName + str(self.nWidgetCount)
		self.nWidgetCount += 1
		self.sWidgets.append(szName)
		return szName

	def deleteWidgets(self):
		screen = self.getScreen()
		for w in self.sWidgets:
			screen.deleteWidget(w)

		self.nWidgetCount = 0
		self.sWidgets = []
		return

	def update(self, fDelta):
		return

	def onClose(self):
		self.LegionMemberCheck.clear()
		self.LegionCoreTroopCheck.clear()
		self.CombatUnitDict.clear()
		return 0

